<?php

namespace HomeDone\CategoryDescription\Block\Category;

/**
 * Class View
 * @package HomeDone\CategoryDescription\Block\Category
 */

class View extends \Magento\Catalog\Block\Category\View
{
    /**
     * @var \Zend_Filter_Interface
     */
    protected $templateProcessor;

    /**
     * View constructor.
     * @param \Magento\Framework\View\Element\Template\Context $context
     * @param \Magento\Catalog\Model\Layer\Resolver $layerResolver
     * @param \Magento\Framework\Registry $registry
     * @param \Magento\Catalog\Helper\Category $categoryHelper
     * @param \Zend_Filter_Interface $templateProcessor
     * @param array $data
     */
    public function __construct(
        \Magento\Framework\View\Element\Template\Context $context,
        \Magento\Catalog\Model\Layer\Resolver $layerResolver,
        \Magento\Framework\Registry $registry,
        \Magento\Catalog\Helper\Category $categoryHelper,
        \Zend_Filter_Interface $templateProcessor,
        array $data = []
    ) {
        parent::__construct(
            $context,
            $layerResolver,
            $registry,
            $categoryHelper,
            $data
        );
        $this->templateProcessor = $templateProcessor;
    }

    /**
     * @param $string
     * @return mixed
     * @throws \Zend_Filter_Exception
     */
    public function filterOutputHtml($string)
    {
        return $this->templateProcessor->filter($string);
    }
}