<?php
/**
 * Emmo.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End-user License Agreement
 *
 * @package     Emmo CustomerRegistrationRedirect v1.x.x
 * @copyright   Copyright (c) 2019 Emmo.
 * @license     End-user License Agreement
 * See COPYING.txt for license details.
 */

namespace Emmo\CustomerRegistrationRedirect\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Customer\Model\Session;

/**
 * Class ModalRegister
 * @package Emmo\CustomerRegistrationRedirect\Observer
 */
class ModalRegister implements ObserverInterface
{
    protected $customerSession;

    public function __construct(
        Session $customerSession
    ) {
        $this->customerSession = $customerSession;
    }

    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $customer = $observer->getEvent()->getCustomer();
        if ($customer->getId()) {
            $this->customerSession->setCustomerRegistrationModal(true);
        }
        return $this;
    }
}