<?php
/**
 * Emmo.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End-user License Agreement
 *
 * @package     Emmo CustomerRegistrationRedirect v1.x.x
 * @copyright   Copyright (c) 2019 Emmo.
 * @license     End-user License Agreement
 * See COPYING.txt for license details.
 */

namespace Emmo\CustomerRegistrationRedirect\Helper;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Store\Model\ScopeInterface;
use Magento\Store\Model\Store;

/**
 * Class Data
 *
 * @package Emmo\CustomerRegistration\Helper
 */
class Data extends AbstractHelper
{
    const REDIRECT_MODULE_ENABLE = 'customerregistrationredirect/general/redirec_setting_enable';

    public function __construct(
        Context $context
    )
    {
        parent::__construct($context);
    }

    public function getRdirectConfig($code, $store = null)
    {
        return $this->scopeConfig->getValue(
            sprintf('customerregistrationredirect/general/%s', $code),
            ScopeConfigInterface::SCOPE_TYPE_DEFAULT,
            $store
        );
    }

    public function isRedirectEnable()
    {
         $isEnabled = true;
         $enabled = $this->scopeConfig->getValue(self::REDIRECT_MODULE_ENABLE, ScopeInterface::SCOPE_STORE);
        if ($enabled == null || $enabled == '0') {
            $isEnabled = false;
        }
         return $isEnabled;
    }
}
