<?php
/**
 * Emmo.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End-user License Agreement
 *
 * @package     Emmo CustomerRegistrationRedirect v1.x.x
 * @copyright   Copyright (c) 2019 Emmo.
 * @license     End-user License Agreement
 * See COPYING.txt for license details.
 */

namespace Emmo\CustomerRegistrationRedirect\Plugin\Controller\Redirect;

use Magento\Customer\Model\Session;

class Modal
{
    /**
     * @var Session
     */
    protected $session;
    protected $redirectHelper;

    public function __construct(
        Session $session,
        \Emmo\CustomerRegistrationRedirect\Helper\Data $redirectHelper
    )
    {
        $this->session = $session;
        $this->redirectHelper = $redirectHelper;
    }

    public function afterExecute($subject, $result)
    {
        $configval = $this->redirectHelper->getRdirectConfig('redirect_setting_mapping');
        $configval = json_decode($configval);
        $configval = (array)$configval;
        foreach($configval as $key => $value)
        {
            $checkvalueToRedirect = (array) $value;
            if ($checkvalueToRedirect['event_options'] == 'register' && $checkvalueToRedirect['customer_group'] == $this->getCustomerGroupId() ) {
                switch ($checkvalueToRedirect['redirect_options']) {
                    case 'home':
                        $result->setPath('home');
                        break;
                    case 'popup':
                        $result->setPath('customer/redirect/modal');
                        break;
                    case 'customurl':
                        $result->setPath($checkvalueToRedirect['custom_url']);
                        break;
                    default:
                        $result->setPath('*/*/');
                        break;
                }
            } else { 
                $result->setPath('*/*/');
            }
        }
        return $result;
    }

    public function getCustomerGroupId()
    {
        if ($this->session->isLoggedIn()) {
            return $this->session->getCustomer()->getGroupId();
        }
    }
}
