<?php
/**
 * Emmo.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End-user License Agreement
 *
 * @package     Emmo CustomerRegistrationRedirect v1.x.x
 * @copyright   Copyright (c) 2019 Emmo.
 * @license     End-user License Agreement
 * See COPYING.txt for license details.
 */
namespace Emmo\CustomerRegistrationRedirect\Controller\Redirect;

use Magento\Customer\Api\AccountManagementInterface as CustomerAccountManagement;
use Magento\Customer\Model\Session;
use Magento\Customer\Model\Url as CustomerUrl;
use Magento\Framework\App\Action\Context;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Newsletter\Model\SubscriberFactory;
use Magento\Framework\Controller\ResultFactory;

/**
 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
 */

class Subscribe extends \Magento\Framework\App\Action\Action

{
    /**
     * @var CustomerAccountManagement
     */
    protected $customerAccountManagement;

    /**
     * Initialize dependencies.
     *
     * @param Context $context
     * @param SubscriberFactory $subscriberFactory
     * @param Session $customerSession
     * @param StoreManagerInterface $storeManager
     * @param CustomerUrl $customerUrl
     * @param CustomerAccountManagement $customerAccountManagement
     */
    public function __construct(
        Context $context,
        SubscriberFactory $subscriberFactory,
        Session $customerSession,
        StoreManagerInterface $storeManager,
        CustomerUrl $customerUrl,
        ResultFactory $resultPageFactory,
        CustomerAccountManagement $customerAccountManagement
    ) {
        $this->customerAccountManagement = $customerAccountManagement;
        $this->resultPageFactory = $resultPageFactory;
        $this->_subscriberFactory = $subscriberFactory;

        parent::__construct(
            $context           
        );
    }

    /**
     * New subscription action
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     * @return void
     */
    public function execute()
    {
        $email = (string)$this->getRequest()->getPost('email');
        try {
            $subscriber = $this->_subscriberFactory->create()->loadByEmail($email);
            if ($subscriber->getId()
                && $subscriber->getSubscriberStatus() == \Magento\Newsletter\Model\Subscriber::STATUS_SUBSCRIBED
            ) {
                $result['message'] = __('This email address is already subscribed.');
                throw new \Magento\Framework\Exception\LocalizedException(
                    __('This email address is already subscribed.')
                );
            }
            $status = $this->_subscriberFactory->create()->subscribe($email);
            if ($status == \Magento\Newsletter\Model\Subscriber::STATUS_NOT_ACTIVE) {
                $result['success'] = __('The confirmation request has been sent.');
            } else {
                $result['success'] = __('Thank you for your subscription.');
            }
        } catch (\Magento\Framework\Exception\LocalizedException $e) {
            $result['message'] = __('There was a problem with the subscription: %1', $e->getMessage());
        } catch (\Exception $e) {
            $result['message'] = __('Something went wrong with the subscription.');
        }
        $resultJson = $this->resultPageFactory->create(ResultFactory::TYPE_JSON);
        $resultJson->setData($result);
        return $resultJson;
     }
}
