<?php
/**
 * Emmo.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End-user License Agreement
 *
 * @package     Emmo CustomerRegistrationRedirect v1.x.x
 * @copyright   Copyright (c) 2019 Emmo.
 * @license     End-user License Agreement
 * See COPYING.txt for license details.
 */

namespace Emmo\CustomerRegistrationRedirect\Model\Config\Source;

use Magento\Framework\Option\ArrayInterface;

class RedirectOptions implements ArrayInterface
{
    const REDIRECT_POPUP = 'popup';
    const REDIRECT_CUSTOM_URL = 'customurl';
    const REDIRECT_HOME_PAGE = 'home';

    /**
     * @return array
     */
    public function toOptionArray()
    {
        return [
            ['value' => '', 'label' => __('-- Please Select --')],
            ['value' => self::REDIRECT_POPUP, 'label' => 'popup'],
            ['value' => self::REDIRECT_CUSTOM_URL, 'label' => 'customurl'],
            ['value' => self::REDIRECT_HOME_PAGE, 'label' => 'home page']
        ];
    }
}
