<?php
/**
 * Emmo.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End-user License Agreement
 *
 * @package     Emmo CustomerRegistrationRedirect v1.x.x
 * @copyright   Copyright (c) 2019 Emmo.
 * @license     End-user License Agreement
 * See COPYING.txt for license details.
 */

namespace Emmo\CustomerRegistrationRedirect\Model\Config\Source;

use Magento\Framework\Option\ArrayInterface;

class GroupOptions implements ArrayInterface
{
    /**
     * @var CustomerGroup $customerGroup
     */
    protected $customerGroup;

    public function __construct(
        \Magento\Customer\Model\ResourceModel\Group\Collection $customerGroup
    )
    {
        $this->customerGroup = $customerGroup;
    }

    /**
     * Get customer groups
     *
     * @return array
     */
    public function toOptionArray()
    {
        $customerGroups = $this->customerGroup->toOptionArray();
        array_shift($customerGroups);
        array_splice($customerGroups, 0,0);
        array_unshift($customerGroups, array('value' => '', 'label' => __('-- Please Select --')));
        return $customerGroups;
    }
}
