<?php
/**
 * Emmo.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End-user License Agreement
 *
 * @package     Emmo CustomerRegistrationRedirect v1.x.x
 * @copyright   Copyright (c) 2019 Emmo.
 * @license     End-user License Agreement
 * See COPYING.txt for license details.
 */

namespace Emmo\CustomerRegistrationRedirect\Model\Config\Source;

use Magento\Framework\Option\ArrayInterface;

class EventOptions implements ArrayInterface
{
    const EVENT_LOGIN = 'login';
    const EVENT_LOGOUT = 'logout';
    const EVENT_REGISTER = 'register';

    /**
     * @return array
     */
    public function toOptionArray()
    {
        return [
            ['value' => '', 'label' => __('-- Please Select --')],
            ['value' => self::EVENT_LOGIN, 'label' => 'login'],
            ['value' => self::EVENT_LOGOUT, 'label' => 'logout'],
            ['value' => self::EVENT_REGISTER, 'label' => 'register']
        ];
    }
}
