<?php
/**
 * Emmo.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End-user License Agreement
 *
 * @package     Emmo CustomerRegistrationRedirect v1.x.x
 * @copyright   Copyright (c) 2019 Emmo.
 * @license     End-user License Agreement
 * See COPYING.txt for license details.
 */
namespace Emmo\CustomerRegistrationRedirect\Block\Adminhtml\Config;

use Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray;
use Emmo\CustomerRegistrationRedirect\Model\Config\Source\GroupOptions;
use Magento\Backend\Block\Template\Context;
use Magento\Framework\Data\Form\Element\Factory;
use Emmo\CustomerRegistrationRedirect\Model\Config\Source\RedirectOptions as RedirectOpt;
use Emmo\CustomerRegistrationRedirect\Model\Config\Source\EventOptions;

class RedirectOptions extends AbstractFieldArray
{
    /**
     * @var GroupOptions
     */
    public $groupOptions;

    /**
     * @var RedirectOptions
     */
    public $redirectOptions;

    /**
     * @var \Magento\Framework\Data\Form\Element\Factory
     */
    public $elementFactory;

    /**
     * @var \Magento\Framework\View\Element\BlockInterface
     */
    public $getDatafieldRenderer;

    /**
     *@var $eventOptions
     */
    public $eventOptions;

    /**
     * OrderStatus constructor.
     *
     * @param Context $context
     * @param Factory $elementFactory
     * @param GroupOptions $magentoOrderStatus
     * @param RedirectOptions $billieStatus
     * @param array $data
     */
    public function __construct(
        Context $context,
        Factory $elementFactory,
        GroupOptions $groupOptions,
        RedirectOpt $redirectOptions,
        EventOptions $eventOptions,
        array $data = []
    )
    {
        $this->elementFactory = $elementFactory;
        $this->_addAfter = false;
        $this->groupOptions = $groupOptions;
        $this->redirectOptions = $redirectOptions;
        $this->eventOptions = $eventOptions;

        $this->_addButtonLabel = __('Add');
        parent::__construct($context, $data);
    }

    /**
     * @return void
     */
    public function _prepareToRender()
    {
        $this->addColumn(
            'customer_group',
            [
                'label' => __('Customer group'),
                'style' => 'width:120px',
            ]
        );
        $this->addColumn(
            'event_options',
            [
                'label' => __('Event'),
                'style' => 'width:120px',
            ]
        );
        $this->addColumn(
            'redirect_options',
            [
                'label' => __('Redirect to'),
                'style' => 'width:120px',
            ]
        );
        $this->addColumn('custom_url',
            [
                'label' => __('Custom url'),
                'style' => 'width:200px',
            ]
        );
    }

    /**
     * @param string $columnName
     *
     * @return string
     */
    public function renderCellTemplate($columnName)
    {
        if ($columnName == 'customer_group' && isset($this->_columns[$columnName])) {
            $options = $this->groupOptions->toOptionArray();
            $element = $this->elementFactory->create('select');
            $element->setForm(
                $this->getForm()
            )->setName(
                $this->_getCellInputElementName($columnName)
            )->setHtmlId(
                $this->_getCellInputElementId('<%- _id %>', $columnName)
            )->setValues(
                $options
            );

            return str_replace("\n", '', $element->getElementHtml());
        }

        if ($columnName == 'event_options' && isset($this->_columns[$columnName])) {
            $options = $this->eventOptions->toOptionArray();
            $element = $this->elementFactory->create('select');
            $element->setForm(
                $this->getForm()
            )->setName(
                $this->_getCellInputElementName($columnName)
            )->setHtmlId(
                $this->_getCellInputElementId('<%- _id %>', $columnName)
            )->setValues(
                $options
            );

            return str_replace("\n", '', $element->getElementHtml());
        }
        if ($columnName == 'redirect_options' && isset($this->_columns[$columnName])) {
            $options = $this->redirectOptions->toOptionArray();
            $element = $this->elementFactory->create('select');
            $element->setForm(
                $this->getForm()
            )->setName(
                $this->_getCellInputElementName($columnName)
            )->setHtmlId(
                $this->_getCellInputElementId('<%- _id %>', $columnName)
            )->setValues(
                $options
            );

            return str_replace("\n", '', $element->getElementHtml());
        }
        return parent::renderCellTemplate($columnName);
    }
}
